/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;

public abstract class C1541Runner
extends Event {
    protected final EventScheduler c64Context;
    protected final EventScheduler c1541Context;
    private int conversionFactor;
    private int accum;
    private long c64LastTime;

    public C1541Runner(EventScheduler c64Context, EventScheduler c1541Context) {
        super("C64 permits C1541 to continue");
        this.c64Context = c64Context;
        this.c1541Context = c1541Context;
        this.c64LastTime = c64Context.getTime(Event.Phase.PHI2);
    }

    protected int updateSlaveTicks(long offset) {
        long oldC64Last = this.c64LastTime;
        this.c64LastTime = this.c64Context.getTime(Event.Phase.PHI2) + offset;
        this.accum += this.conversionFactor * (int)(this.c64LastTime - oldC64Last);
        int wholeClocks = this.accum >> 16;
        this.accum &= 0xFFFF;
        return wholeClocks;
    }

    public void setClockDivider(CPUClock clock) {
        this.conversionFactor = (int)(1000000.0 / clock.getCpuFrequency() * 65536.0 + 0.5);
    }

    public void reset() {
        this.c64LastTime = this.c64Context.getTime(Event.Phase.PHI2);
    }

    public abstract void cancel();

    public abstract void synchronize(long var1);
}

